﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel.Composition;
using System.IO;
using System.ServiceModel;
// These namespaces are found in the Microsoft.Xrm.Sdk.dll assembly
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Client;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Crm.Sdk.Samples;
using Microsoft.Uii.Common.Entities;
using Microsoft.Xrm.Tooling;
using Microsoft.Xrm.Tooling.PackageDeployment;
using Microsoft.Xrm.Tooling.PackageDeployment.CrmPackageExtentionBase;

namespace BTSSS.CRM.Configurations.Deployment
{
    /// <summary>
    /// Demonstrates how to upload attachments to an annotation and how to download attachments.
    /// </summary>
    public class AnnotationData
    {

        #region Class Level Members

        private Guid _annotationId;
        private OrganizationServiceProxy _serviceProxy;
        private String _fileName;
        private Microsoft.Xrm.Tooling.Connector.CrmServiceClient _crmSvcClient;
        private Microsoft.Xrm.Sdk.EntityCollection _sourceAnnotations;

        #endregion Class Level Members

        #region Constructors
        public AnnotationData(Microsoft.Xrm.Tooling.Connector.CrmServiceClient crmSvcClient)
        {
            _crmSvcClient = crmSvcClient;
        }
        #endregion Constructors

        #region Extract Annotations 
        /// <summary>
        /// Extract the annotations. 
        /// </summary>
        public void Extract()
        {
            QueryExpression query = new QueryExpression
            {
                EntityName = "annotation",
                ColumnSet = new ColumnSet(true)
            };
            _sourceAnnotations = _crmSvcClient.RetrieveMultiple(query);
            
            //todo: write to tooling log
            //Console.WriteLine("Attachment downloaded.");
        }
        /// <summary>
        /// Extracts an annotation record to a specific folder path.
        /// </summary>
        /// <param name="folderPath"></param>
        public void Extract(string folderPath)
        {
            Extract();
            foreach (Annotation sourceAnnotation in _sourceAnnotations.Entities)
            {
                // Download the attachment in the current execution folder.
                string fileName = sourceAnnotation.FileName;
                using (FileStream fs = new FileStream(fileName, FileMode.OpenOrCreate))
                {
                    
                }
            };
        }
        #endregion
        /// <summary>
        /// Imports an annotation record into the CRM Organization.
        /// </summary>
        public void Import()
        {
            foreach (Annotation retrievedAnnotation in _sourceAnnotations.Entities)
            {
                _annotationId = _serviceProxy.Create(retrievedAnnotation);
            };
        }

        /// <summary>
        /// Imports the annotations (attachments) from a specified foldre path.
        /// </summary>
        /// <param name="folderPath"></param>
        public void Import(string folderPath)
        {
            if (Directory.Exists(folderPath))
            {
                // Process the list of files found in the directory.
                foreach (string fileName in Directory.GetFiles(folderPath))
                {
                    using (FileStream fs = new FileStream(fileName, FileMode.Open, FileAccess.Read))
                    {
                        using (BinaryReader r = new BinaryReader(fs))
                        {
                            for (int i = 0; i < 11; i++)
                            {
                                Console.WriteLine(r.ReadInt32());
                            }
                        }
                    }
                }
            }
        }

        /// <summary>
        /// Deletes an annotation (attachment) from the CRM Organization. 
        /// to delete the records created in this sample.</param>
        /// </summary>
        public void Delete(Guid annotationId)
        {
            _serviceProxy.Delete(Annotation.EntityLogicalName, _annotationId);
            File.Delete(_fileName);
            Console.WriteLine("Entity records have been deleted.");
        }


        private void BinaryWrite(FileStream fileStream)
        {
            using (BinaryWriter w = new BinaryWriter(fileStream))
            {
                for (int i = 0; i < 11; i++)
                {
                    w.Write(i);
                }
            }
        }

        private void BinaryRead(FileStream fileStream)
        {

        }
    }
}
